//==================================================================================
// t@C	Fmain.cpp
// Tv			FGLUT TvvOueB[|bgv
// 		F2006/06/26/	쐬
//				F2008/10/23/	GLUI 
// 		F@MV
//==================================================================================
#include <stdlib.h>
#include <stdio.h>
#include <windows.h>
#include <math.h>
#include <time.h>		// time(), localtime()
#include <GL/glut.h>

#include "glui.h"		// GLUI
#pragma comment(lib, "glui32.lib")

/* }N` */
//#define MY_DOUBLE_FLAG		// _uobt@O̎wiw肵ȂƂ̓RgAEgj
#define PI 3.141592			// ~
#define PROGRAM_NAME "GLUT test"	// vO
#define REDRAW_TIME 100		// ĕ`ij

/* O[oϐ錾 */
int g_w, g_h;				// EBhEA
int	g_DisplayMode;			// \@iPFRAOFQj
double g_polar[3];			// R_̋ɍWiAӁAƁj
double g_teapot[3];			// eB[|bg̒WiAAj
double g_angle;				// eB[|bgpϐ

// for GLUI (added 2008/10/27)
int g_MainWindow;
GLUI *glui;
GLUI_RadioGroup *myRadioGroup;
GLUI_Spinner *mySpinner;
int g_Speed;
int g_State;				// ԁiPFUAOF~j

/* ֐vg^Cv錾 */
void resize(int, int);
void display(void);
void timer(int);
void keyboard(unsigned char, int, int);
void skeyboard(int, int, int);
void mouse(int, int, int, int);
void init(void);
void CloseWnd(void);
void DataSave(char *, char *);

//==========================================================================
//    gluiCallback	FfkthɊ֘A鏈
//==========================================================================
void gluiCallback(int num) {
	switch(num){
		case 0:	// Start/Stop
			if(g_State==0)	g_State=1;
			else			g_State=0;
			break;
		case 1:	// 2D / 3D
			break;
		case 2:	// Speed
			break;
		case 3:	// Exit
			CloseWnd();
			break;
		default:
			break;
	}
}

//==========================================================================
//    main	FC[v֐
//==========================================================================
int main(int argc, char **argv){
	glutInitWindowPosition(0, 0);
	glutInitWindowSize(640, 480);
	glutInit(&argc, argv);
#ifdef MY_DOUBLE_FLAG
	glutInitDisplayMode(GLUT_RGBA | GLUT_DEPTH | GLUT_DOUBLE);
#else
	glutInitDisplayMode(GLUT_RGBA | GLUT_DEPTH);
#endif
	g_MainWindow = glutCreateWindow(PROGRAM_NAME);
	glutReshapeFunc(resize);
	glutDisplayFunc(display);
	glutTimerFunc(REDRAW_TIME, timer, 0);
	glutKeyboardFunc(keyboard);
	glutSpecialFunc(skeyboard);
	glutMouseFunc(mouse);
    init();

	/* GLUI settings */
	glui = GLUI_Master.create_glui("GLUI test", 0, 660, 0);	// GLUI
	glui->add_button("Start / Stop", 0, gluiCallback);
	glui->add_separator();
	myRadioGroup = glui->add_radiogroup(&g_DisplayMode, 1, gluiCallback);
	glui->add_radiobutton_to_group( myRadioGroup, "2D" );	// WI{^ׂ͕ 0, 1, ...
	glui->add_radiobutton_to_group( myRadioGroup, "3D" );
	myRadioGroup->set_int_val(1);	// default 3D
	mySpinner = glui->add_spinner("Speed", GLUI_SPINNER_INT, &g_Speed, 2, gluiCallback);
	mySpinner->set_int_limits(0, 10, GLUI_LIMIT_CLAMP);		// l͈̔͂𐧌
	mySpinner->set_int_val(5);		// default medium speed
	glui->add_separator();
	glui->add_button("Exit", 3, gluiCallback);

	glutMainLoop();
	return 0;
}

//==========================================================================
//    resize	FEChETCYύXꂽɎs֐
//==========================================================================
void resize(int w, int h){
	g_w=w; g_h=h;
	glViewport(0, 0, w, h);	// EBhEŜr[|[gɂ
	glLoadIdentity();		// ϊs̏
	gluPerspective(30.0, (double)w/(double)h, 1.0, 100.0);
	if(g_DisplayMode==0) gluLookAt(0.0, 0.0, 50.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	else				 gluLookAt(
		g_polar[0]*cos(g_polar[1])*cos(g_polar[2]), 
		g_polar[0]*sin(g_polar[1])*cos(g_polar[2]), 
		g_polar[0]*sin(g_polar[2]), 
		0.0, 0.0, 1.0, 0.0, 0.0, 1.0);
}

//==========================================================================
//    display	FEChEɕ`悷֐
//==========================================================================
void display(void){
	int i;

	resize(g_w, g_h);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	/* ` */
	glPushMatrix();
	glColor3d(1.0, 1.0, 0.0);
	glTranslated(g_teapot[0], g_teapot[1], g_teapot[2]);
	glLineWidth(1);
	glutWireTeapot(4);
	glPopMatrix();

	glPushMatrix();
	glColor3d(1.0, 1.0, 1.0);	// 
	glLineWidth(2);
	glBegin(GL_LINES);
	glVertex3d(0.0, -40.0, 0.0);
	glVertex3d(0.0, 40.0, 0.0);
	glVertex3d(-40.0, 0.0, 0.0);
	glVertex3d(40.0, 0.0, 0.0);
	glVertex3d(0.0, 0.0, 0.0);
	glVertex3d(0.0, 0.0, 20.0);
	for(i=0; i<10; i++){	// ڐ
		glVertex3d(i+1.0, 1.0, 0.0);
		glVertex3d(i+1.0, -1.0, 0.0);
	}
	for(i=0; i<10; i++){	// cڐ
		glVertex3d(0.0, 1.0, i+1.0);
		glVertex3d(0.0, -1.0, i+1.0);
	}
	glEnd();
	glPopMatrix();

#ifdef MY_DOUBLE_FLAG
	glutSwapBuffers();
#else
	glFlush();
#endif
}

//==========================================================================
//    timer	FJԂ
//==========================================================================
void timer(int){
	glutSetWindow(g_MainWindow);

	if(g_State==1){
		glutPostRedisplay();
		g_teapot[0] = 5*cos(g_angle);
	//	g_angle += 5*PI/180;
		g_angle += g_Speed*PI/180;
	}

	/* gČĂяo */
	glutTimerFunc(REDRAW_TIME, timer, 0);
}

//==========================================================================
//    keyboard	FL[ꂽɎs֐
//==========================================================================
void keyboard(unsigned char key, int x, int y){
	switch (key) {	
	    case 'q':
		case 'Q':
		case '\033':	// \033  ESC  ASCII R[h
			CloseWnd();
			break;
		case 'r':
/*			if(g_DisplayMode==0)	g_DisplayMode=1;	// R\
			else					g_DisplayMode=0;	// Q\*/
			if(g_DisplayMode==0)	myRadioGroup->set_int_val(1);	// R\
			else					myRadioGroup->set_int_val(0);	// Q\
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			glutPostRedisplay();
			break;
		default:
			break;
	}
}

//==========================================================================
//    skeyboard	FL[ꂽɎs֐
//==========================================================================
void skeyboard(int key, int x, int y){
	//_ʒu
	switch (key) {
	case GLUT_KEY_LEFT:	//L[
		g_polar[1] -= 5*2*PI/360;
		glutPostRedisplay();
		break;
	case GLUT_KEY_UP:	//L[
		if(g_polar[2] < PI/2.0 - 5*PI/180) g_polar[2] += 5*PI/180;
		glutPostRedisplay();
		break;
	case GLUT_KEY_RIGHT://L[E
		g_polar[1] += 5*2*PI/360;
		glutPostRedisplay();
		break;
	case GLUT_KEY_DOWN:	//L[
		if(g_polar[2] > -PI/2.0 + 5*PI/180) g_polar[2] -= 5*PI/180;
		glutPostRedisplay();
		break;
	case GLUT_KEY_PAGE_UP:
		g_polar[0] += 1;
		glutPostRedisplay();
		break;
	case GLUT_KEY_PAGE_DOWN:
		if(g_polar[0] > 2) g_polar[0] -= 1;
		glutPostRedisplay();
		break;
	default:
		break;
	}
}

//==========================================================================
//    mouse	F}EX̃{^ꂽɎs֐
//==========================================================================
void mouse(int button, int state, int x, int y){
	if(state==GLUT_UP){
		switch (button) {
		case GLUT_LEFT_BUTTON:
			break;
		case GLUT_MIDDLE_BUTTON:
			break;
		case GLUT_RIGHT_BUTTON:
			break;
		default:
			break;
		}
	}
}

//==========================================================================
//    init	F֐
//==========================================================================
void init(void){
	glClearColor(0.0, 0.0, 0.0, 0.0);
	glEnable(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
//	g_DisplayMode=1;	// R\
	g_polar[0]=50; g_polar[1]=60*PI/180; g_polar[2]=25*PI/180;
	g_teapot[0]=5; g_teapot[1]=5; g_teapot[2]=0;
	g_angle=0;
	g_State=1;			// U
}

//==========================================================================
//    CloseWnd	FfoCXEBhȄI
//==========================================================================
void CloseWnd(){
	/* EBhEI */
	exit(0);
}

//==========================================================================
//    DataSave	Ff[^t@Cɕۑ
//==========================================================================
void DataSave(char *folder, char *databuf){
	HANDLE hFile;
	DWORD dwAccBytes;
	time_t t;
	struct tm *t_st;
	char sFileName[128];

	CreateDirectory(folder, NULL);
	time(&t);
	t_st = localtime(&t);
	strcpy(sFileName, "");
	sprintf(sFileName, "./%s/%dN%d%d%d%d%db.txt", 
		folder, 
		t_st->tm_year+1900, t_st->tm_mon+1, t_st->tm_mday, t_st->tm_hour, t_st->tm_min, t_st->tm_sec);
	
	hFile = CreateFile(sFileName, GENERIC_WRITE, 0, 0, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	WriteFile(hFile, databuf, strlen(databuf), &dwAccBytes, NULL);
	CloseHandle(hFile);
}