/* }N` */
#define MAX_REPEAT 3000	// ő唽
#define THRESHOLD 0.5	// ĨXbVh
#define ALPHA 0.001		// xNgɂd

/* ֐vg^Cv錾 */
void SetTriangle(void);
double diff_X(int);
double diff_Y(int);
double func(void);
double bibun_theta(void);
double bibun_RX(void);
double bibun_RY(void);
void Steepest(void);

//==========================================================================
//    SetTriangle	FOp``Caݒ
//==========================================================================
void SetTriangle(void){
	int i;

	VecSet(g_A[0], 0.0, 0.0);
	VecSet(g_A[1], 5.0, 0.0);
	VecSet(g_A[2], 4.0, 4.2);
	for(i=0; i<3; i++) VecRot(g_A[i], PI/2.0);

	VecSet(g_B[0],  7.0, 5.0);
	VecSet(g_B[1], 12.0, 5.0);
	VecSet(g_B[2], 11.0, 9.2);

	for(i=0; i<3; i++) VecSet(g_C[i], g_B[i].x, g_B[i].y);

	VecSet(g_R, 0.0, 0.0);
	g_theta = 0.0;
}

//==========================================================================
//    diff_X	FxNg`Ca̍xNĝ
//==========================================================================
double diff_X(int i){
	return cos(g_theta)*(g_B[i].x + g_R.x) - sin(g_theta)*(g_B[i].y + g_R.y) - g_A[i].x;
}

//==========================================================================
//    diff_Y	FxNg`Ca̍xNĝ
//==========================================================================
double diff_Y(int i){
	return sin(g_theta)*(g_B[i].x + g_R.x) + cos(g_theta)*(g_B[i].y + g_R.y) - g_A[i].y;
}

//==========================================================================
//    func	Fŏ֐
//==========================================================================
double func(void){
	double tmp=0.0;
	for(int i=0; i<3; i++) tmp += pow(diff_X(i), 2.0) + pow(diff_Y(i), 2.0);
	return tmp;
}

//==========================================================================
//    bibun_theta	FƔ
//==========================================================================
double bibun_theta(void){
	double tmp=0.0;
	for(int i=0; i<3; i++)
		tmp += 2.0*(-sin(g_theta)*(g_B[i].x + g_R.x) - cos(g_theta)*(g_B[i].y + g_R.y)) * diff_X(i)
		     + 2.0*( cos(g_theta)*(g_B[i].x + g_R.x) - sin(g_theta)*(g_B[i].y + g_R.y)) * diff_Y(i);
	return tmp;
}

//==========================================================================
//    bibun_RX	FxNgq̂
//==========================================================================
double bibun_RX(void){
	double tmp=0.0;
	for(int i=0; i<3; i++) tmp += 2.0*cos(g_theta)*diff_X(i) + 2.0*sin(g_theta)*diff_Y(i);
	return tmp;
}

//==========================================================================
//    bibun_RY	FxNgq̂
//==========================================================================
double bibun_RY(void){
	double tmp=0.0;
	for(int i=0; i<3; i++) tmp += -2.0*sin(g_theta)*diff_X(i) + 2.0*cos(g_theta)*diff_Y(i);
	return tmp;
}

//==========================================================================
//    Steepest	Fŋ}~@
//==========================================================================
void Steepest(void){
	double bibun[3];
	
	SetTriangle();

	for(int k=0; k<MAX_REPEAT; k++){	// ő唽
		bibun[0] = bibun_theta();
		bibun[1] = bibun_RX();
		bibun[2] = bibun_RY();

		// I
		if(	fabs(bibun[0]) < THRESHOLD &&
			fabs(bibun[1]) < THRESHOLD &&
			fabs(bibun[2]) < THRESHOLD) break;

		// l̍XV
		g_theta -= ALPHA * bibun[0];
		g_R.x   -= ALPHA * bibun[1];
		g_R.y   -= ALPHA * bibun[2];

		for(int i=0; i<3; i++){
			VecSet(g_C[i], g_B[i].x, g_B[i].y);
			VecAdd(g_C[i], g_R, 1.0);
			VecRot(g_C[i], g_theta);
		}
		// oߊmFiȉprintfdisplay()RgAEgƑj
		printf("%d\t%lf\t%lf\t%lf\t%lf\n", k, bibun[0], bibun[1], bibun[2], func());
		display();
	}
	printf("%d\t%lf\t%lf\t%lf\t%lf\n", k, bibun[0], bibun[1], bibun[2], func());
	printf("k\tbibun[0]\tbibun[1]\tbibun[2]\tfunc\n");
	printf("\ntheta[deg] = %lf\tRX = %lf\tRY = %lf\n", g_theta*180/PI, g_R.x, g_R.y);
}
