//==================================================================================
// t@CFglut.cpp
// Tv		 FGLUT TvvO
//   F2005/02/14/	쐬
// ҁ@@F@MV
//==================================================================================
#include <stdlib.h>
#include <stdio.h>
#include <GL/glut.h>
#include <math.h>

/* }N` */
#define PI 3.14159265358979323846	// ~
#define TITLEBAR "'s GLUT Sample"	// ^Cgo[

/* O[oϐ錾 */
//_̋ɍW
double R;
double ganma;
double theta;
//_̒W
double eyePosition[3];
//̈ʒuƐF
float light0pos[] = { 100.0, 0.0, 100.0, 1.0 };
float light0color[] = { 1.0, 0.0, 0.0, 1.0  };

/* ֐vg^Cv錾 */
void idle(void);
void display(void);
void resize(int w, int h);
void mouse(int button, int state, int x, int y);
void keyboard(unsigned char key, int x, int y);
void skeyboard(int key, int x, int y);
void init(void);

//==========================================================================
//    main	FC[v֐
//==========================================================================
int main(int argc, char *argv[]){
	// EBhE쐬
	glutInit(&argc, argv);
	glutInitWindowPosition(100, 100);
	glutInitWindowSize(480, 360);
	glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
	glutCreateWindow(TITLEBAR);
	glutDisplayFunc(display);
	glutReshapeFunc(resize);
	glutMouseFunc(mouse);
	glutKeyboardFunc(keyboard);
	glutSpecialFunc(skeyboard);
	glutIdleFunc(idle); 
    init();

	glutMainLoop();
	return 0;
}

//==========================================================================
//    idle	FɂȎɎs֐
//==========================================================================
void idle(void){
	glutPostRedisplay();
}

//==========================================================================
//    display	FEChEɕ`悷֐
//==========================================================================
void display(void){
	int i;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();

	//_ʒuiɍW璼Wɕϊj
	eyePosition[0] = R*cos(ganma)*cos(theta);
	eyePosition[1] = R*sin(ganma);	
	eyePosition[2] = R*cos(ganma)*sin(theta);
	//EChEɕ`ʂꍇɏƂȂxNg
	double WindowTopVector[] = {0, 1, 0};
	//_ʒu畨̂
	gluLookAt(
		eyePosition[0], eyePosition[1], eyePosition[2],
		0, 0, 0,
		WindowTopVector[0], WindowTopVector[1], WindowTopVector[2]);

	//`
	glPushMatrix();
	glColor3d(0.5, 0.5, 1.0);
	glutWireTeapot(70.0);
	glPopMatrix();

	//obt@ւ
	glutSwapBuffers();
}

//==========================================================================
//    resize	FEChETCYύXꂽɎs֐
//--------------------------------------------------------------------------
//  
//    int	w		FEChE̕
//    int	h		FEChE̍
//==========================================================================
void resize(int w, int h){
	glViewport(0, 0, w, h);

	//ϊs̐ݒ
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
    gluPerspective(100.0, (double)w/(double)h, 1.0, 1000.0);

	//fr[ϊs̐ݒ
	glMatrixMode(GL_MODELVIEW);
}

//==========================================================================
//    mouse	F}EX̃{^ꂽɎs֐
//--------------------------------------------------------------------------
//  
//    int	button		Fꂽ{^
//    int	state		F̂̂
//    int	x		FW
//    int	y		FW
//==========================================================================
void mouse(int button, int state, int x, int y){
	switch (button) {
	case GLUT_LEFT_BUTTON:
		break;
	case GLUT_MIDDLE_BUTTON:
		break;
	case GLUT_RIGHT_BUTTON:
		break;
	default:
		break;
	}
}

//==========================================================================
//    keyboard	FL[ꂽɎs֐
//--------------------------------------------------------------------------
//  
//    int	key		FꂽL[
//    int	x		Fꂽ̃}EX̂W
//    int	y		Fꂽ̃}EX̂W
//==========================================================================
void keyboard(unsigned char key, int x, int y){
	switch (key) {	
	    case 'q':
		case 'Q':
		case '\033':	// \033  ESC  ASCII R[h
			exit(0);
			break;
		case 'p':	// n_ʒu\
			printf("_ʒu = ( %f, %f, %f )\n", eyePosition[0], eyePosition[1], eyePosition[2]);
			break;
		default:
			break;
	}
}

//==========================================================================
//    skeyboard	FL[ꂽɎs֐
//--------------------------------------------------------------------------
//  
//    int	key		FꂽL[
//    int	x		Fꂽ̃}EX̂W
//    int	y		Fꂽ̃}EX̂W
//==========================================================================
void skeyboard(int key, int x, int y){
	//_ʒu
	switch (key) {
	case GLUT_KEY_LEFT://L[
		theta += 5*2*PI/360;
		glutPostRedisplay();
		break;
	case GLUT_KEY_UP://L[
		ganma += 5*2*PI/360;
		glutPostRedisplay();
		break;
	case GLUT_KEY_RIGHT://L[E
		theta -= 5*2*PI/360;
		glutPostRedisplay();
		break;
	case GLUT_KEY_DOWN://L[
		ganma -= 5*2*PI/360;
		glutPostRedisplay();
		break;
	case GLUT_KEY_PAGE_UP:
		R += 5;
		glutPostRedisplay();
		break;
	case GLUT_KEY_PAGE_DOWN:
		R -= 5;
		if(R < 5) R = 5;
		glutPostRedisplay();
		break;
	default:
		break;
	}
}

//==========================================================================
//    init	F֐
//==========================================================================
void init(void){
	glClearColor(1.0, 1.0, 1.0, 0.0);
	glEnable(GL_DEPTH_TEST);
	R = 200.0;
	ganma = 0.0;
	theta = 90.0*2*PI/360;
}

